package jcircus.environment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jcircus.util.CircusType;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;

/**
 * @author aff
 *
 */
public class TypeList {
    
    /**
     * List of CircusType. Contains a list of non-generic types.
     */
    private List typeList_;
    
    /**
     * Index for creating java names for compound types.
     */
    public static int index = 0;
    
    /**
     * Constructor.
     *
     */
    public TypeList() {
        this.typeList_ = new ArrayList();
    }
    
    /**
     *
     * @param circusType
     */
    public void addType(CircusType circusType) {
        
        String javaName;
        
        // Adds the type to the type list
        this.typeList_.add(circusType);        
    }
    
    /**
     * Create a java name for the type represented by the give expression.
     * If the type is a basic name (given or free type), the java name will
     * be the basic name; otherwise, it will be "Type_xx", where xx is an
     * index.
     *
     * Not used for the moment.
     *
     */
    private String createJavaName(Expr expr) {
        
        String javaName;
        
        if (expr instanceof RefExpr) {
            javaName = ((RefExpr) expr).getRefName().toString();
        } else {
            javaName = "Type_" + index;
            index++;
        }
        
        return javaName;
    }
    
    /**
     *
     * @return
     */
    public Iterator iterator() {
        return this.typeList_.iterator();
    }
    
    /**
     *
     * @return
     */
    public int size() {
        return this.typeList_.size();
    }
    
    /**
     *
     * @param circusType
     * @return
     */
    public boolean contains(CircusType circusType) {
        return this.typeList_.contains(circusType);
    }
    
    /**
     *
     * @param circusType
     * @return
     */
    public int indexOf(CircusType circusType) {
        return this.typeList_.indexOf(circusType);
    }
    
    /**
     *
     * @param index
     * @return
     */
    public CircusType elementAt(int index) {
        return (CircusType) this.typeList_.get(index);
    }
}
